using System.Collections.Generic;
using UnityEngine;
using System.Linq;
using UnityEngine.UI;
using System.Text;
namespace scene9
{
    public class Internet : MonoBehaviour
    {
        List<Computer> computerList;
        List<Link> linksList;
        public InputField input;
        public Text text;
        private void Awake()
        {
            linksList = new List<Link>();
            computerList = new List<Computer>();
        }
        public void CreateInternet()
        {
            StringBuilder result = new StringBuilder();
            string[] strings = input.text.Split('\n');
            int computerNum = int.Parse(strings[0].Split(' ')[0]);
            foreach (var id in Enumerable.Range(1, computerNum))
            {
                computerList.Add(new Computer(id));
            }
            int dayNum = int.Parse(strings[0].Split(' ')[1]);
            var stringsBody = strings.Skip(1).ToArray();
            foreach (var day in Enumerable.Range(0, dayNum))
            {
                var numLine = Trans(stringsBody[day * 3 + 0]);
                foreach (var submitIndex in Enumerable.Range(0, numLine.First()))
                {
                    var nums = numLine.Skip(1).Skip(submitIndex * 4).Take(4).ToArray();
                    AddLink(nums[0], nums[1], nums[2], nums[3]);
                }
                numLine = Trans(stringsBody[day * 3 + 1]);
                foreach (var submitIndex in Enumerable.Range(0, numLine.First()))
                {
                    var num = numLine.Skip(1).Skip(submitIndex * 1).Take(1).Single();
                    result.AppendLine(Find(num).MainTarget().ToString());
                }
                numLine = Trans(stringsBody[day * 3 + 2]);
                var numArray = numLine.ToArray();
                if (numArray[0] == 1) result.AppendLine(SilosNum.ToString());
                if (numArray[1] == 1) result.AppendLine(PairsNum.ToString());
                ToNextDay();
            }
            text.text = result.ToString();
        }
        IEnumerable<int> Trans(string strLine) => from str in strLine.Split(' ') select int.Parse(str);
        void AddLink(int sourceID, int targetID, int mb, int duration)
        {
            var link = new Link(Find(sourceID), Find(targetID), mb, duration);
            linksList.Add(link);
            link.source.AddLink(link);
            link.target.AddLink(link);
        }
        void ToNextDay()
        {
            linksList.RemoveAll(link => link.ToNextDay());
            computerList.ForEach(computer => computer.links.RemoveAll(link => link.duration <= 0));
        }
        Computer Find(int id) => computerList.Find(computer => computer.id.Equals(id));
        //µ
        int SilosNum => computerList.Where(computer => computer.links.Count == 0).Count();
        //ͨŶ
        int PairsNum => linksList.Where(link => link.IsPair).Count();
    }
    public class Computer
    {
        public readonly int id;
        public List<Link> links;
        public int MainTarget()
        {
            if (links.Count == 0) return 0;
            return links[links.Count - 1].Other(this).id;
        }
        public Computer(int _id)
        {
            id = _id;
            links = new List<Link>();
        }
        public void AddLink(Link link) 
        {
            links.Add(link); 
            links.Sort((i, j) => i.mb==j.mb? i.Other(this).id.CompareTo(-j.Other(this).id):i.mb.CompareTo(j.mb)); 
        }
    }
    public class Link
    {
        public Computer source;
        public Computer target;
        public int mb;
        public int duration;
        public Link(Computer _source, Computer _target, int _mb, int _duration)
        {
            (source, target, mb, duration) = (_source, _target, _mb, _duration);
        }
        public bool ToNextDay() => --duration <= 0;
        public bool IsPair => source.MainTarget() == target.id && target.MainTarget() == source.id;
        public Computer Other(Computer self)=> source.id == self.id ? target : source;
    }
}