using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System.Linq;

namespace scene7
{
    public class TrainCal : MonoBehaviour
    {

        public Transform content;
        public GameObject mes;
        public InputField input;

        public void Cal()
        {
            ClearMessages();

            string[] txt = input.text.Split(' ');

            var nums = GetIntArray(txt);

            if (nums is null) return;

            Execute(nums);

        }

        public int[] GetIntArray(string[] txt)
        {
            int[] nums = new int[txt.Length];
            int index = 0;
            foreach (var num in from str in txt select int.Parse(str))
            {
                if(num >=1 && num<=5)
                {
                    nums[index++] = num;
                }
                else
                {
                    AddMessage("ÿӦ1~5ѳΧ");
                    return null;
                }
            }

            if(nums.Sum()>100)
            {
                AddMessage("100");
                return null;
            }

            return nums;
        }

        public void Execute(int[] nums)
        {
            LinkedStackList<int> list = new LinkedStackList<int>(20, 5);
            foreach (var num in Enumerable.Range(1,100).Reverse())
            {
                list.Push(num);
            }
            foreach (var num in nums)
            {
                AddMessage(string.Join(' ',list.PopNear(num)));
            }
        }

        public void AddMessage(string str)
        {
            var obj = Get(content);
            obj.GetComponent<Text>().text = str;
        }

        public void ClearMessages()
        {
            while(content.transform.childCount>0)
            {
                Release(content.transform.GetChild(0).gameObject);
            }

        }

        //Mini Object Pool
        List<GameObject> ObjectPool = new List<GameObject>(64);
        private void Release(GameObject obj)
        {
            obj.SetActive(false);
            obj.transform.SetParent(null);
            ObjectPool.Add(obj);
        }
        private GameObject Get(Transform parent)
        {
            GameObject obj;
            if (ObjectPool.Count > 0)
            {
                obj = ObjectPool[0];
                obj.transform.SetParent(parent, true);
                ObjectPool.RemoveAt(0);
            }
            else
            {
                obj = Instantiate(mes, parent);
            }
            obj.SetActive(true);
            return obj;
        }

        private class LinkedStack<T>
        {
            Stack<T> stack;
            int maxSize;

            public LinkedStack<T> last;
            public LinkedStack<T> next;
            public int Count => stack.Count;
            public LinkedStack(int capacity)
            {
                maxSize = capacity;
                stack = new Stack<T>(maxSize);
            }
            public void Push(T obj)
            {
                if(stack.Count==maxSize)
                {
                    next.Push(obj);
                }
                else
                {
                    stack.Push(obj);
                }
            }
            public T Pop()
            {
                if (stack.Count == 0)
                {
                    return last.Pop();
                }
                else
                {
                    return stack.Pop();
                }
            }
        }

        private class LinkedStackList<T>
        {
            LinkedStack<T> start;
            LinkedStack<T> end;
            int length;
            public LinkedStackList(int length, int eachSize)
            {
                this.length = length;
                start = new LinkedStack<T>(eachSize);
                LinkedStack<T> past = start;
                LinkedStack<T> now = start;
                foreach (var i in Enumerable.Range(0, length-1))
                {
                    now = new LinkedStack<T>(eachSize);
                    now.last = past;
                    past.next = now;
                    past = past.next;
                }
                end = now;
            }

            public void Push(T obj)
            {
                start.Push(obj);
            }
            public T Pop()
            {
                return end.Pop();
            }
            public T[] PopNear(int count)
            {
                T[] result = new T[count];

                var temp = end;

                int index = length;

                while(index>0)
                {
                    if (temp.Count >= count)
                    {
                        return Pop(temp);
                    }
                    else
                    {
                        temp = temp.last;
                        index--;
                    }
                }

                return Pop(end);

                T[] Pop(LinkedStack<T> linked)
                {
                    foreach (var i in Enumerable.Range(0, count))
                        result[i] = linked.Pop();
                    return result;
                }
            }
        }

    }
}