using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
using System.Linq;
using System.Diagnostics;
using Debug = UnityEngine.Debug;

namespace scene6
{
    public class Sort8 : MonoBehaviour
    {
        //ϢϢ
        public GameObject mes;
        public GameObject content;

        //ĳߴ
        const int SampleSize = 50000;
        const int SampleCount = 10;

        //
        int[][] sample;

        //вԣťʱ
        public void Execute()
        {
            GetRandomSample();
            Statistic();
        }

        //ȡΪ
        private void GetRandomSample()
        {
            sample = new int[SampleCount][];
            for (int sampleIndex = 0; sampleIndex < SampleCount; sampleIndex++)
            {
                sample[sampleIndex] = new int[SampleSize];
                for (int index = 0; index < SampleSize; index++)
                {
                    //-99999100000
                    sample[sampleIndex][index] = UnityEngine.Random.Range(-100000, 100000);
                }
            }

            //ʹ1Ϊ2Ϊ
            List<int> positive = new List<int>(sample[0]);
            positive.Sort((a, b) => a.CompareTo(b));
            List<int> reverse = new List<int>(sample[1]);
            reverse.Sort((a, b) => -a.CompareTo(b));
            sample[0] = positive.ToArray();
            sample[1] = reverse.ToArray();

            //ɵݵָļ
            for(int index = 0;index<SampleCount;index++)
            {
                Utility.SL.Saver.SaveSingle(sample[index], "Sample" + index, Application.streamingAssetsPath + "/scene6");
            }
        }

        //Ը㷨Ϣ
        private void Statistic()
        {
            List<Action<int[]>> sortActs = new List<Action<int[]>>()
            {
                StraightInsertionSort,
                ShellSort,
                BubbleSort,
                QuickSort,
                SelectSort,
                HeapSort,
                MergeSort,
                RadixSort
            };
            int SortKinds = sortActs.Count;

            //ÿ㷨Ӧÿʱ
            List<double[]> sortTimeForEachSample = new List<double[]>(8);
            for (int sortIndex = 0; sortIndex < SortKinds; sortIndex++)
            {
                sortTimeForEachSample.Add(new double[SampleCount]);
                for (int sampleIndex = 0; sampleIndex < SampleCount; sampleIndex++)
                {
                    sortTimeForEachSample[sortIndex][sampleIndex] =
                        DoSortWithSingleSample(sortActs[sortIndex], sample[sampleIndex]);
                }
            }

            //ݲʮʱ䣬㷨ʱ
            sortTimeForEachSample.Sort((a, b) => a.Sum().CompareTo(b.Sum()));

            //
            foreach (var index in Enumerable.Range(0, SortKinds))
            {
                foreach(var sampleIndex in Enumerable.Range(0,SampleCount))
                {
                    var m = Instantiate(mes, content.transform);
                    m.GetComponent<UnityEngine.UI.Text>().text = 
                        sortActs[index].Method.Name + " SampleCount" + sampleIndex + ":" +sortTimeForEachSample[index][sampleIndex] + "ms";
                }

                //Debug.Log(sortActs[index].Method.Name + " SumTime:" + sortTimeForEachSample[index].Sum() + "ms");
                Debug.Log(sortActs[index].Method.Name + " AverageTime:" + sortTimeForEachSample[index].Sum()/SampleCount + "ms");
            }
        }

        //ָ㷨ָʱ
        private double DoSortWithSingleSample(Action<int[]> sortAct, int[] sample)
        {
            //֮ǰʹDateTime¼ʱ䣬ҲľȲ
            //ʹרڲʱStopWatch

            Stopwatch watch = new Stopwatch();
            watch.Start();

            sortAct.Invoke(sample);

            watch.Stop();

            return watch.ElapsedTicks * 1000.0 / Stopwatch.Frequency;
        }

        private void StraightInsertionSort(int[] sample)
        {
            int n = SampleSize;
            for (int i = 1; i < n; i++)
            {
                if (sample[i] < sample[i - 1])
                {
                    int value = sample[i];
                    int j;
                    //Ӻǰsample[i]ӦڵλãŲ
                    for (j = i - 1; j >= 0 && value < sample[j]; j--)
                    {
                        sample[j + 1] = sample[j];
                    }
                    //sample[i]Ӧڵλã滻
                    sample[j + 1] = value;
                }
            }
        }

        private void ShellSort(int[] sample)
        {
            int n = SampleSize;
            //ÿѭ롣
            int gap;
            for (gap = n / 2; gap > 0; gap /= 2)
            {
                // gap飬ÿֱӲ
                for (int i = 0; i < gap; i++)
                {
                    for (int j = i + gap; j < n; j += gap)
                    {
                        // sample[j] < sample[j-gap]Ѱsample[j]λãݶơ
                        if (sample[j] < sample[j - gap])
                        {
                            int temp = sample[j];
                            int k;
                            for (k = j - gap; k >= 0 && sample[k] > temp; k -= gap)
                            {
                                sample[k + gap] = sample[k];
                            }
                            sample[k + gap] = temp;
                        }
                    }
                }
            }
        }

        private void BubbleSort(int[] sample)
        {
            int temp;
            int n = SampleSize;
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < n - 1; j++)
                {
                    if (sample[j] > sample[j + 1])
                    {
                        //
                        temp = sample[j];
                        sample[j] = sample[j + 1];
                        sample[j + 1] = temp;
                    }
                }
            }
        }

        private void QuickSort(int[] sample)
        {

            int Sort(int[] arr, int left, int right)
            {
                // ڱֲ arr[left] Ϊ׼
                int i = left, j = right;

                int temp;

                while (i < j)
                {//ע⣺whileѭ˳ܷһѡ߽Ϊ׼ֵôͱȴұ߿ʼ
                    while (i < j && arr[j] >= arr[left]) j--;
                    while (i < j && arr[i] <= arr[left]) i++;
                    temp = arr[i];
                    arr[i] = arr[j];
                    arr[j] = temp;
                }
                //ѭ
                temp = arr[i];
                arr[i] = arr[left];
                arr[left] = temp;

                return i;
            }

            //ʹջ¼ÿλֺλãԴ
            Stack<Vector2Int> stack = new Stack<Vector2Int>();

            int left = 0;
            int right = sample.Length - 1;
            if (left < right)
            {
                int pivot = Sort(sample, left, right);
                if (pivot - 1 >= left)
                {
                    stack.Push(new Vector2Int(left, pivot - 1));
                }
                if (pivot + 1 <= right)
                {
                    stack.Push(new Vector2Int(pivot + 1, right));
                }
                while (stack.Count > 0)
                {
                    Vector2Int record = stack.Pop();
                    pivot = Sort(sample, record[0], record[1]);
                    if (pivot - 1 >= record[0])
                    {
                        stack.Push(new Vector2Int(record[0], pivot - 1));
                    }
                    if (pivot + 1 <= record[1])
                    {
                        stack.Push(new Vector2Int(pivot + 1, record[1]));
                    }
                }
            }

        }

        private void SelectSort(int[] sample)
        {
            int n = sample.Length;
            for (int i = 0; i < n; i++)
            {
                int min = sample[i];
                for (int j = i + 1; j < n; j++)
                {
                    if (min < sample[j]) continue;
                    int temp = min;
                    min = sample[j];
                    sample[j] = temp;
                }
            }
        }

        private void HeapSort(int[] sample)
        {

            HeapInsert(sample);
            int n = sample.Length;
            while (n > 1)
            {
                //̶ֵ
                int temp = sample[0];
                sample[0] = sample[n - 1];
                sample[n - 1] = temp;
                n -= 1;
                //
                Heapify(sample, 0, n);
            }

            //ѣͨ²
            void HeapInsert(int[] array)
            {
                for (int i = 0; i < array.Length; i++)
                {
                    //ǰ
                    int currentIndex = i;
                    //
                    int fatherIndex = (currentIndex - 1) / 2;
                    //ǰֵ丸ֵ,򽻻ֵҽָ򸸽
                    //ȻĸֵȽϣֱڸ㣬˳ѭ
                    while (array[currentIndex] > array[fatherIndex])
                    {
                        //ǰ븸ֵ
                        int temp = array[currentIndex];
                        array[currentIndex] = array[fatherIndex];
                        array[fatherIndex] = temp;
                        //ǰָ
                        currentIndex = fatherIndex;
                        //¼㵱ǰĸ
                        fatherIndex = (currentIndex - 1) / 2;
                    }
                }
            }
            //ʣɴѣͨ˵½
            void Heapify(int[] array, int index, int size)
            {
                int left = 2 * index + 1;
                int right = 2 * index + 2;
                while (left < size)
                {
                    int largestIndex;
                    //жϺнϴֵҪȷҺsizeΧ֮ڣ
                    if (array[left] < array[right] && right < size)
                    {
                        largestIndex = right;
                    }
                    else
                    {
                        largestIndex = left;
                    }
                    //Ƚϸֵ뺢нϴֵȷֵ
                    if (array[index] > array[largestIndex])
                    {
                        largestIndex = index;
                    }
                    //ֵѾǴˣ˳ѭ
                    if (index == largestIndex)
                    {
                        break;
                    }
                    //㲻ֵ뺢нϴֵ
                    int temp = array[largestIndex];
                    array[largestIndex] = array[index];
                    array[index] = temp;
                    //ָнϴֵ
                    index = largestIndex;
                    //¼㽻֮ĺӵ
                    left = 2 * index + 1;
                    right = 2 * index + 2;
                }
            }
        }

        private void MergeSort(int[] sample)
        {
            int n = sample.Length;
            int[] p = new int[n];
            mergesort(sample, 0, n - 1, p);

            void mergesort(int[] a, int first, int last, int[] temp)
            {
                if (first < last)
                {
                    int mid = (first + last) / 2;
                    mergesort(a, first, mid, temp);    //
                    mergesort(a, mid + 1, last, temp); //ұ
                    mergearray(a, first, mid, last, temp); //ٽкϲ
                }
            }

            //жa[first...mid]a[mid...last]ϲ
            void mergearray(int[] a, int first, int mid, int last, int[] temp)
            {
                int i = first, j = mid + 1;
                int m = mid, n = last;
                int k = 0;

                while (i <= m && j <= n)
                {
                    if (a[i] <= a[j])
                        temp[k++] = a[i++];
                    else
                        temp[k++] = a[j++];
                }

                while (i <= m)
                    temp[k++] = a[i++];

                while (j <= n)
                    temp[k++] = a[j++];

                for (i = 0; i < k; i++)
                    a[first + i] = temp[i];
            }
        }

        private void RadixSort(int[] sample)
        {
            List<int> list = new List<int>(sample);
            int maxValue = list.Max();
            int minAbsValue = Mathf.Abs(list.Min());

            //Ҫѭ9-1 99-2 999-3
            int it = 0;

            List<List<int>> buckets = new List<List<int>>(10);//10бӦ0-9
                                                              //бʼС
            for (int i = 0; i < 10; i++)
            {
                buckets.Add(new List<int>());
            }

            while (Math.Pow(10, it) <= maxValue)
            {
                //Ͱ
                for (int i = 0; i < list.Count; i++)
                {
                    //989 it=0 989/10^it=989 989%10=9;
                    int digit = (int)(((list[i] + minAbsValue) / Math.Pow(10, it)) % 10);
                    //õӦб
                    buckets[digit].Add(list[i]);
                }
                //list
                list.Clear();
                //ȡ
                for (int i = 0; i < buckets.Count; i++)
                {
                    list.AddRange(buckets[i]);
                }
                it += 1;

                //бһѭ
                buckets.ForEach(bucket => bucket.Clear());
            }
        }
    }
}