using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.IO;
using System.Text;

namespace scene5
{
    public class HuffmanCode : MonoBehaviour
    {
        public List<TextAsset> sources;

        public TextAsset source;

        List<HuffmanNode> charsList = new List<HuffmanNode>(64);
        Dictionary<char, string> codeDic = new Dictionary<char, string>(64);

        HuffmanNode root;

        //
        public void Change(int num)
        {
            source = sources[Mathf.Clamp(num,0,sources.Count)];
            charsList.Clear();
            codeDic.Clear();
        }

        public void Execute()
        {
            Statistics();
            CreateHuffmanTree();
            WriteHuffman();
            Code();
            ReCode();
        }

        //ͳƸִַ
        public void Statistics()
        {
            string txt = source.text;
            //ֵַĴ
            Dictionary<char, int> charsDic = new Dictionary<char, int>(64);
            foreach (var c in txt)
            {
                if (!charsDic.TryAdd(c, 1))
                    charsDic[c]++;
            }
            //תList
            foreach (var pair in charsDic)
            {
                charsList.Add(new HuffmanNode(pair.Key, pair.Value));
            }
            // 
            charsList.Sort((a, b) => a.num.CompareTo(b.num));
        }

        //
        public void CreateHuffmanTree()
        {
            List<HuffmanNode> tempList = new List<HuffmanNode>(charsList);
            while (tempList.Count > 1)
            {
                var min1 = tempList[0];
                var min2 = tempList[1];
                tempList.RemoveRange(0, 2);
                var parent = new HuffmanNode(min1, min2);
                tempList.Add(parent);
                tempList.Sort((a, b) => a.num.CompareTo(b.num));
            }
            root = tempList[0];
        }

        //¼ִַͶӦ
        public void WriteHuffman()
        {
            if (!Directory.Exists(Application.streamingAssetsPath + "/scene5"))
            {
                Directory.CreateDirectory(Application.streamingAssetsPath + "/scene5");
            }
            var file = File.CreateText(Application.streamingAssetsPath + $"/scene5/{source.name} Huffman.txt");
            foreach (var charNode in charsList)
            {
                //Եֱӵõ
                string code = charNode.OriginalCode;
                codeDic.TryAdd(charNode.symbol, code);
                file.WriteLine($"{charNode.symbol}:{charNode.num} {code}");
            }
            file.Dispose();
        }

        //
        public void Code()
        {
            List<byte> bytes = new List<byte>(1024);
            StringBuilder unit = new StringBuilder();
            string txt = source.text;
            foreach (var c in txt)
            {
                unit.Append(codeDic[c]);
            }
            //01ַ
            string byteString = unit.ToString();
            int index = 0;
            while (index < byteString.Length / 8)
            {
                string sub = byteString.Substring(index * 8, 8);
                bytes.Add(System.Convert.ToByte(System.Convert.ToInt32(sub, 2)));
                index++;
            }
            //пȱ
            if (byteString.Length % 8 != 0)
            {
                StringBuilder sub = new StringBuilder();
                sub.Append(byteString[(index * 8)..]);
                if (sub.Length < 8) sub.Append('0');
                if (sub.Length < 8) sub.Append('0');
                while (sub.Length < 8) sub.Append('1');
                bytes.Add(System.Convert.ToByte(System.Convert.ToInt32(sub.ToString(), 2)));
            }
            var file = File.Create(Application.streamingAssetsPath + $"/scene5/{source.name} code.dat");
            bytes.ForEach(Byte => file.WriteByte(Byte));
            file.Dispose();
        }

        //
        public void ReCode()
        {
            var read = File.OpenRead(Application.streamingAssetsPath + $"/scene5/{source.name} code.dat");
            var binary = new BinaryReader(read);
            //ȡеbyte
            byte[] bytesArray = binary.ReadBytes((int)read.Length);

            int byteIndex = 0;
            int bitIndex = 0;
            HuffmanNode nowNode = root;

            var write = File.CreateText(Application.streamingAssetsPath + $"/scene5/{source.name} recode.txt");

            while (byteIndex < bytesArray.Length)
            {
                if (nowNode.leftChild is null && nowNode.rightChild is null)
                {
                    write.Write(nowNode.symbol);
                    nowNode = root;
                }

                int value = GetBitValue(bytesArray[byteIndex], 7 - bitIndex);
                if (value == 1) nowNode = nowNode.leftChild;
                else nowNode = nowNode.rightChild;

                bitIndex += 1;
                if (bitIndex > 7)
                {
                    bitIndex -= 8;
                    byteIndex += 1;
                }
            }

            read.Dispose();
            write.Dispose();
        }

        //ȡֽĳһλֵ0~7
        public int GetBitValue(byte value, int index)
        {
            byte val = (byte)(1 << index);
            return (value & val) == val ? 1 : 0;
        }
    }
    public class HuffmanNode
    {
        public char symbol;
        public int num;

        public HuffmanNode parent;
        public HuffmanNode leftChild;
        public HuffmanNode rightChild;

        //ȡԭ
        public string OriginalCode
        {
            get
            {
                if (parent is null) return "";
                if (parent.leftChild is not null && this == parent.leftChild) return parent.OriginalCode + "1";
                if (parent.rightChild is not null && this == parent.rightChild) return parent.OriginalCode + "0";
                else return "";
            }
        }
        //ڵ
        public HuffmanNode(HuffmanNode _leftChild, HuffmanNode _rightChild)
        {
            leftChild = _leftChild;
            leftChild.parent = this;
            rightChild = _rightChild;
            rightChild.parent = this;
            num = leftChild.num + rightChild.num;
        }
        //ֽڵ
        public HuffmanNode(char _sym, int _num)
        {
            symbol = _sym;
            num = _num;
        }
    }
}
