using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using UnityEngine.UI;

namespace scene4
{
    public class NJBus : MonoBehaviour
    {
        Dictionary<string, Node> stops;
        Dictionary<string, Node> lines;
        public TextAsset txt;
        public GameObject content;
        public GameObject mes;
        public InputField from;
        public InputField to;
        private void Awake()
        {
            CreateGraph();
        }
        private void Execute(System.Action<Stop, Stop> action)
        {
            ClearMessage();
            if (GetInput(out Node nodeFrom, out Node nodeTo))
                action.Invoke((Stop)nodeFrom, (Stop)nodeTo);
        }
        public void Execute_Stop()
        {
            Execute(PrintNearestByStop);
        }
        public void Execute_Line()
        {
            Execute(PrintNearestByLine);
        }
        private bool GetInput(out Node nodeFrom, out Node nodeTo)
        {
            if (from.text.Length == 0) from.text = "¥ҽԺվ";
            if (!stops.TryGetValue(from.text, out nodeFrom))
            {
                AddMessage("δҵվ");
                nodeTo = null;
                return false;
            }
            if (to.text.Length == 0) to.text = "½վ";
            if (!stops.TryGetValue(to.text, out nodeTo))
            {
                AddMessage("δҵĿվ");
                return false;
            }
            return true;
        }

        private void CreateGraph()
        {
            //2022.10.27 507·ߣ8684վ
            stops = new Dictionary<string, Node>(10000);
            lines = new Dictionary<string, Node>(1000);

            //վ֮ı
            string[] strings = txt.text.Split('\n');
            foreach (var stringline in strings)
            {
                CreateGraph_LoadLine(stringline);
            }

            //·֮ı
            foreach (Line line in lines.Values)
            {
                line.stops.ForEach(stop => line.AddNextRange(TryGetStop(stop).lines));
                line.nexts.Distinct();
            }
        }

        private void CreateGraph_LoadLine(string stringline)
        {
            //ʽոΪ
            stringline = System.Text.RegularExpressions.Regex.Replace(stringline, @"\s+", ",").Trim(',');
            string[] stringnode = stringline.Split(',');

            //·
            Line line = new Line(stringnode[0]);
            lines.Add(line.id, line);

            int length = stringnode.Length;
            for (int index = 1; index < length; index++)
            {
                Stop now = TryGetStop(stringnode[index]);

                line.AddStop(now.id);

                now.AddLine(line.id);

                //ǰڵΪԼڽڵ
                if (index - 1 > 0)
                {
                    now.AddNext(stringnode[index - 1]);
                }
                if (index + 1 < length)
                {
                    now.AddNext(stringnode[index + 1]);
                }
            }
        }

        private Stop TryGetStop(string id)
        {
            //ԴֵҵĿ꣬ûоʹһ
            if (!stops.TryGetValue(id, out Node result))
            {
                result = new Stop(id);
                stops.Add(id, result);
            }
            return (Stop)result;
        }

        private void PrintNearestByStop(Stop start, Stop end)
        {
            //ȡվ·
            var target = FindNearestBFS(stops, start, stop => stop.id == end.id);

            //¿ʼ
            var builder = new System.Text.StringBuilder();

            var old = target.Pop();
            builder.Append(start.id);
            builder.Append("");
            AppendNowLine(start);
            builder.Append("->");

            while (target.Count > 1)
            {
                var temp = target.Pop();
                builder.Append(temp);
                bool isTrans = true;

                foreach (var (now, next) in from i in ((Stop)stops[old]).lines from j in ((Stop)stops[target.Peek()]).lines select (i, j))
                {
                    if (now == next)
                    {
                        isTrans = false;
                    }
                }
                if (isTrans)
                {
                    builder.Append("");
                    AppendNowLine((Stop)stops[temp]);
                }

                builder.Append("->");
                old = temp;
            }

            void AppendNowLine(Stop stop)
            {
                foreach (Line line in from linestr in stop.lines select lines[linestr])
                {
                    if (line.HasStop(target.Peek()))
                    {
                        builder.Append(line.id);
                        break;
                    }
                }
            }
            builder.Append("Ŀĵ");
            builder.Append(end.id);

            AddMessage(builder.ToString());
        }

        private void PrintNearestByLine(Stop start, Stop end)
        {
            //Ӳͬվȡת·
            List<Stack<string>> traces = new List<Stack<string>>();
            foreach (var path in start.lines)
            {
                traces.Add(FindNearestBFS(lines, (Line)lines[path], line => end.lines.Contains(line.id)));
            }
            //traces.ForEach(t => Debug.Log(t.Count));
            traces.Sort((x, y) => x.Count.CompareTo(y.Count));

            var target = traces[0];

            //¿ʼ

            var builder = new System.Text.StringBuilder();
            builder.Append("");
            builder.Append(start.id);
            while (target.Count > 1)
            {
                var temp = target.Pop();
                builder.Append("");
                builder.Append(temp);
                foreach (var (now, next) in from i in ((Line)lines[temp]).stops from j in ((Line)lines[target.Peek()]).stops select (i, j))
                {
                    if (now == next)
                    {
                        builder.Append("");
                        builder.Append(now);
                        builder.Append("");
                        break;
                    }

                }
                builder.Append("->");
            }
            builder.Append("");
            builder.Append(target.Pop());
            builder.Append("Ŀĵ");
            builder.Append(end.id);
            AddMessage(builder.ToString());
        }

        private Stack<string> FindNearestBFS(Dictionary<string, Node> dic, Node start, System.Predicate<Node> compare)
        {
            //ǷѾ
            Dictionary<string, bool> hasChecked = new Dictionary<string, bool>(dic.Count);
            //켣 AڵBCʱֱBCΪAΪֵ
            Dictionary<string, string> trace = new Dictionary<string, string>(dic.Count);
            foreach (var node in dic.Keys)
            {
                hasChecked.Add(node, false);
            }

            List<Node> temp = new List<Node>(dic.Count);
            List<Node> temp2 = new List<Node>(32);

            temp.Add(start);

            int num = 0;

            while (temp.Count > 0)
            {
                //ҵ
                var find = temp.Find(compare);
                if (find is not null)
                {
                    return ToPath(trace, find.id, start.id);
                }

                //
                temp.ForEach(node =>node.nexts.ForEach(next =>
                {
                    if (!hasChecked[next])
                    {
                        hasChecked[next] = true;
                        trace.Add(next, node.id);
                        temp2.Add(dic[next]);
                    }
                }));

                temp.Clear();
                temp.AddRange(temp2);
                temp2.Clear();

                num++;
                //100վ100·߻ûôһǳ
                if (num > 100)
                {
                    Debug.Log("ѭ");
                    break;
                }
            }

            return null;
        }

        private Stack<string> ToPath(Dictionary<string, string> trace, string end, string start)
        {
            Stack<string> path = new Stack<string>();
            for (string traceStop = end; traceStop != start; traceStop = trace[traceStop])
            {
                path.Push(traceStop);
            }
            path.Push(start);
            return path;
        }

        public void AddMessage(string message)
        {
            Get(content.transform).GetComponent<Text>().text = message;
        }

        public void ClearMessage()
        {
            while (content.transform.childCount > 0)
            {
                Release(content.transform.GetChild(0).gameObject);
            }
        }

        //Mini Object Pool
        List<GameObject> ObjectPool = new List<GameObject>(64);
        private void Release(GameObject obj)
        {
            obj.SetActive(false);
            obj.transform.SetParent(null);
            ObjectPool.Add(obj);
        }
        private GameObject Get(Transform parent)
        {
            GameObject obj;
            if (ObjectPool.Count > 0)
            {
                obj = ObjectPool[0];
                obj.transform.SetParent(parent, true);
                ObjectPool.RemoveAt(0);
            }
            else
            {
                obj = Instantiate(mes, parent);
            }
            obj.SetActive(true);
            return obj;
        }
    }

    public abstract class Node
    {
        public string id;
        public List<string> nexts;

        public Node(string id)
        {
            this.id = id;
            nexts = new List<string>(4);
        }
        public void AddNext(string next)
        {
            if (!nexts.Contains(next))
                nexts.Add(next);
        }
        public void AddNextRange(List<string> nextRange)
        {
            nexts.AddRange(nextRange);
        }
    }
    public class Stop : Node
    {
        public List<string> lines;
        public Stop(string id) : base(id) { lines = new List<string>(); }
        public void AddLine(string line)
        {
            lines.Add(line);
        }
    }
    public class Line : Node
    {
        public List<string> stops;
        public Line(string id) : base(id) { stops = new List<string>(); }
        public void AddStop(string stop)
        {
            stops.Add(stop);
        }
        public bool HasStop(string stop)
        {
            return stops.Contains(stop);
        }
    }


}
