using System.Collections;
using System.Collections.Generic;
using UnityEngine;
namespace scene3
{
    public class TreeCal : MonoBehaviour
    {
        public UnityEngine.UI.InputField input;
        public UnityEngine.UI.Text text;
        public void Cal()
        {
            string str = input.text;
            Tree tree = new Tree(str);
            text.text = "·"+tree.GetSpecialPathNum().ToString();
        }
    }

    public class Tree
    {
        List<TreeNode> nodes = new List<TreeNode>();
        public Tree(string str)
        {
            CreateTree(str.Split(' '));
        }
        private void CreateTree(params string[] nums)
        {
            for(int index=1;index<=nums.Length;index++)
            {
                var node = new TreeNode(index, int.Parse(nums[index - 1]));
                nodes.Add(node);
            }
            //ֱӱøڵ Ӷn^2
            nodes.ForEach(node => { if (node.parentIndex > 0) node.parent = nodes[node.parentIndex - 1]; });
        }
        public int GetSpecialPathNum()
        {
            int num = 0;
            //Ѱ· Ӷn^2
            for (int i = 1; i <= nodes.Count; i++)
            {
                for(int j=1;j<=nodes.Count;j++)
                {
                    //Ҫa<b
                    if (i >= j) continue;
                    if (IsSpecialPath(nodes[i - 1], nodes[j - 1])) num++;
                }
            }
                return num;
        }
        private bool IsSpecialPath(TreeNode a,TreeNode b)
        {
            //ҵαȽͼи±ߣĽڵ
            TreeNode highLevel = a;
            TreeNode lowLevel = b;
            if(a.Level<b.Level)
            {
                highLevel = b;
                lowLevel = a;
            }

            //±ߵĽڵһߣֱһڵ㵽һΣвĽڵͷ
            while(highLevel.Level>lowLevel.Level)
            {
                highLevel = highLevel.parent;
                if (!highLevel.IsIndexIn(a.index, b.index)) return false;
            }

            //ڵͬʱߣֱߵһ飬вĽڵͷ
            while (highLevel.index!=lowLevel.index)
            {
                highLevel = highLevel.parent;
                lowLevel = lowLevel.parent;
                if (!highLevel.IsIndexIn(a.index, b.index)) return false;
                if (!lowLevel.IsIndexIn(a.index, b.index)) return false;
            }

            //е˵ڵ·ϵнڵ㶼·
            return true;
        }
    }
    public class TreeNode
    {
        //
        public int index;

        //ڵ
        public int parentIndex;

        //ڵ
        public TreeNode parent;

        //㼶ҲǴµڼ
        public int Level => parentIndex==0 ? 1 : parent.Level + 1;
        public TreeNode(int _index,int _parentIndex)
        {
            index = _index;
            parentIndex = _parentIndex;
        }
        public bool IsIndexIn(int n1, int n2) => index >= Mathf.Min(n1, n2) && index <= Mathf.Max(n1, n2);
    }
}
