using System.Collections;
using System.Collections.Generic;
using System.Text;
using UnityEngine;
using UnityEngine.UI;

namespace scene2
{
    public class Calculate : MonoBehaviour
    {
        public static Calculate Ins;
        public List<Transform> contents;
        public InputField input;
        public GameObject mes;
        private void Awake()
        {
            Ins = this;
        }
        public void Cal()
        {
            ClearMessages();
            string expr;
            //Ĭϱʽ
            if (input.text.Length == 0)
                expr = "#(4.4+2*(5-4.8/2))/2+10.4/2#";
            else expr = '#'+input.text.Trim('#')+'#';
            var cal = new CalExpression(expr);
            cal.Execute();
        }

        //Mini Object Pool
        List<GameObject> ObjectPool = new List<GameObject>(64);
        private void Release(GameObject obj)
        {
            obj.SetActive(false);
            obj.transform.SetParent(null);
            ObjectPool.Add(obj);
        }
        private GameObject Get(Transform parent)
        {
            GameObject obj;
            if (ObjectPool.Count > 0)
            {
                obj = ObjectPool[0];
                obj.transform.SetParent(parent, true);
                ObjectPool.RemoveAt(0);
            }
            else
            {
                obj = Instantiate(mes, parent);
            }
            obj.SetActive(true);
            return obj;
        }
        public void AddMessage(MesType type,string str)
        {
            var obj = Get(contents[(int)type]);
            obj.GetComponent<Text>().text = str;
        }

        public void ClearMessages()
        {
            contents.ForEach(obj =>
            {
                while (obj.transform.childCount > 0)
                    Release(obj.GetChild(0).gameObject);
            });
        }
    }
    public enum MesType
    {
        Num = 0,
        Oper = 1,
        Expr = 2,
    }

    //㷨ʽ
    public struct CalExpression
    {
        public const char ERROR = 'E';
        //ջ
        public Stack<float> nums;
        //ջ
        public Stack<char> opers;
        //׺ʽ
        public string expression;

        public CalExpression(string _expression)
        {
            nums = new Stack<float>();
            opers = new Stack<char>();
            expression = _expression;
        }
        public float Execute()
        {
            //ȡһλλָ
            int i = 1;
            //
            int count = 0;
            //1. # ջ
            opers.Push('#');
            while (expression[i]!='#'||opers.Peek()!='#')
            {
                //2.ǲ
                if (IsNum(expression[i]))
                {
                    int index = i;
                    //indexһֱǲΪֹ
                    while(IsNum(expression[index]))
                    {
                        index++;
                    }
                    string number = expression[i..index];

                    //ǲȴתС
                    if(!float.TryParse(number,out float result))
                    {
                        Calculate.Ins.AddMessage(MesType.Expr, "ظС");
                        return ERROR;
                    }
                    nums.Push(result);
                    i = index;
                }
                //3.ǲջűȽȼǷ
                else if (IsOper(expression[i]))
                {
                    switch (Compare(opers.Peek(), expression[i]))
                    {
                        case '<':                                                   //ջԪȼͣջ
                            opers.Push(expression[i]);
                            i++;
                            break;
                        case '=':                                                   //ȼȣ˵ջ (  expression ),ȥ
                            opers.Pop();
                            i++;
                            break;
                        case '>':                                                   //ջԪȼߣ㲢ջ
                            if (!nums.TryPeek(out float opval2))
                            {
                                char warn = opers.Peek();
                                Calculate.Ins.AddMessage(MesType.Expr,$"{warn}ȱ");
                                return ERROR;
                            }
                            nums.Pop();

                            if(!nums.TryPeek(out float opval1))
                            {
                                char warn = opers.Peek();
                                Calculate.Ins.AddMessage(MesType.Expr, $"{warn}ȱ");
                                return ERROR;
                            }
                            nums.Pop();
                            //ջ
                            float result = Caculate(opval1, opers.Peek(), opval2);
                            nums.Push(result);
                            //
                            opers.Pop();
                            break;
                    }
                }
                //Ƿַ
                else
                {
                    Calculate.Ins.AddMessage(MesType.Expr, $"зǷַ{expression[i]}");
                    return ERROR;
                }

                //Ϣ
                count++;
                StringBuilder builder = new StringBuilder();
                builder.Append($"{count} ");
                foreach (var num in nums.ToArray())
                {
                    builder.Append(num.ToString());
                    builder.Append(' ');
                }
                Calculate.Ins.AddMessage(MesType.Num, builder.ToString());
                builder.Clear();
                builder.Append($"{count} ");
                foreach (var oper in opers.ToArray())
                {
                    builder.Append(oper.ToString());
                    builder.Append(' ');
                }
                Calculate.Ins.AddMessage(MesType.Oper, builder.ToString());
                builder.Clear();
                builder.Append($"{count} ");
                builder.Append(expression[i..]);
                Calculate.Ins.AddMessage(MesType.Expr, builder.ToString());
            }
            //4.󷵻ջԪ
            return nums.Peek();
        }

        //Ľ
        public float Caculate(float a, char oper, float b)
            => oper switch
            {
                '+' => a + b,
                '-' => a - b,
                '*' => a * b,
                '/' => a / b,
                _ => ERROR,
            };
        //жǷǲ
        public bool IsNum(char num) => ".0123456789".Contains(num);
        //жǷǲ
        public bool IsOper(char oper) => oper is '+' or'-' or '*' or '/' or '(' or ')' or '#';

        //Ƚϲȼ
        public char Compare(char op1, char op2)
            => op1 switch
            {
                '+' or '-' => op2 switch
                {
                    '+' or '-' or ')' or '#' => '>',
                    _ => '<'
                },
                '*' or '/' => op2 == '(' ? '<' : '>',
                '(' => op2 switch
                {
                    '+' or '-' or '*' or '/' or '(' => '<',
                    ')' => '=',
                    _ => ERROR,
                },
                ')' => op2 switch
                {
                    '+' or '-' or '*' or '/' or ')' or '#' => '>',
                    '(' => ERROR,
                    _ => ERROR,
                },
                '#' => op2 switch
                {
                    ')' => ERROR,
                    '#' => '=',
                    _ => '<',
                },
                _ => ERROR,
            };
    };
}