using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.Linq;
using UnityEngine.UI;

namespace scene18
{
    public class KeywordTree : MonoBehaviour
    {
        public InputField inputWord;
        public InputField inputMeaning;

        KeywordNode root;
        private void Awake()
        {
            root = new KeywordNode(' ', null);
        }
        private KeywordNode FindKeywordNode(string word)
        {
            KeywordNode result = root;
            word.ToList().ForEach(symbol => result = result.GetChild(symbol));
            return result;
        }
        private void ChangeMeaning(string word,string newMeaning)
        {
            FindKeywordNode(word).meaning = newMeaning;
        }
        //ǳڲӿ
        public void ReloadWord(string word)
        {
            Debug.Log(FindKeywordNode(word).meaning);
        }
        public void CreateWord(string word,string meaning)
        {
            ChangeMeaning(word, meaning);
        }
        public void DeleteWord(string word)
        {
            ChangeMeaning(word, default);
        }
        public void UpdateWord(string word, string newMeaning)
        {
            ChangeMeaning(word, newMeaning);
        }
        //ǰťӿ
        public void ReloadWord()
        {
            inputMeaning.placeholder.GetComponent<Text>().text = FindKeywordNode(inputWord.text).meaning;
        }
        public void CreateWord()
        {
            ChangeMeaning(inputWord.text, inputMeaning.text);
            inputWord.text = "";
            inputMeaning.text = "";
        }
        public void DeleteWord()
        {
            ChangeMeaning(inputWord.text, default);
            inputWord.text = "";
            inputMeaning.text = "";
        }
        public void UpdateWord()
        {
            ChangeMeaning(inputWord.text, inputMeaning.text);
            inputWord.text = "";
            inputMeaning.text = "";
        }
    }
    public class KeywordNode
    {
        public readonly char key;
        public string meaning;

        public List<KeywordNode> childs;
        public KeywordNode this[char _key] => FindChildFirst(_key);
        public KeywordNode() {}
        public KeywordNode(char _key, string _meaning = default)
        {
            key = _key;
            meaning = _meaning;
            childs = new List<KeywordNode>();
        }
        public KeywordNode AddChild(KeywordNode add)
        {
            var insertIndex = childs.SkipWhile(child => child.key < add.key).FirstOrDefault();

            if (insertIndex is null)
                childs.Add(add);
            else
                childs.Insert(childs.IndexOf(insertIndex), add);

            return add;
        }
        public KeywordNode FindChildFirst(char _key) 
            => childs.Where(child => child.key.Equals(_key)).FirstOrDefault();

        public KeywordNode GetChild(char _key)
            => FindChildFirst(_key) ?? AddChild(new KeywordNode(_key, default));
    }
}
