using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace scene12
{
    public class SignLayoutFactory
    {
        SignLayout ins;
        int signKinds;


        //ѭƴ
        //
        int limitBase = 500;

        //ÿɣΪƴϴֵ
        int limitAdd = 50;

        //Ժӵĸÿɵ
        int ignoreNum = 6;

        /// <summary>
        /// ½ȷ*ż1ȡ
        /// </summary>
        /// <param name="_length"></param>
        /// <param name="_width"></param>
        public SignLayoutFactory(int _width, int _height)
        {
            //Ҷһ
            int height = _height + 2;
            int width = _width + 2;
            if (height % 2 + width % 2 == 2) width += 1;
            ins = new SignLayout(width, height);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="_signKinds">ͼĿ</param>
        /// <returns></returns>
        public SignLayout Create(int _signKinds)
        {
            signKinds = _signKinds;

            var list = new List<Vector2Int>((ins.width - 2) * (ins.height - 2));

            var result =  GenerateRandomLayout(list);

            //Debug.Log(ignoreNum);

            return result;
        }

        private SignLayout GenerateRandomLayout(List<Vector2Int> list)
        {
            Vector2Int a, b;
            int tryTimes = 0;
            CreateRandomUseableList(list);
            while (IsHaveUseable(list))
            {
                a = GetRandomUseableLocation(list);
                b = GetRandomUseableLocation(list);
                SetRandomSignForPair(a, b);
                //Debug.Log(a.x+" "+a.y+" "+ins.Get(a.x, a.y));
                //Debug.Log(b.x+" "+b.y+" "+ins.Get(b.x, b.y));
                if (list.Count > ignoreNum && !ins.IsCanMatch(a.x, a.y, b.x, b.y))
                {
                    //Debug.Log("Can't Match");
                    ins.Match(a.x, a.y, b.x, b.y);
                    ReleaseRandomUseableLocation(list, a);
                    ReleaseRandomUseableLocation(list, b);
                }
                tryTimes++;
                if (tryTimes > limitBase)
                {
                    //Debug.Log("ѭ");
                    ins.Clear();
                    limitBase += limitAdd;
                    ignoreNum++;
                    return GenerateRandomLayout(list);
                }
            }
            return ins;
        }

        //
        private List<Vector2Int> CreateRandomUseableList(List<Vector2Int> list)
        {
            list.Clear();
            foreach (var (row, col) in
                from i in Enumerable.Range(1, ins.height - 2)
                from j in Enumerable.Range(1, ins.width - 2)
                select (i, j))
                list.Add(new Vector2Int(row, col));
            return list;
        }

        private void SetRandomSignForPair(Vector2Int pos1, Vector2Int pos2)
        {
            Sign random = (Sign)UnityEngine.Random.Range(1, signKinds + 1);
            ins.SetSign(pos1.x, pos1.y, random);
            ins.SetSign(pos2.x, pos2.y, random);
        }

        private bool IsHaveUseable(List<Vector2Int> list) => list.Count > 0;
        private Vector2Int GetRandomUseableLocation(List<Vector2Int> list)
        {
            int random = UnityEngine.Random.Range(0, list.Count);
            var r = list[random];
            list.RemoveAt(random);
            return r;
        }
        private void ReleaseRandomUseableLocation(List<Vector2Int> list, Vector2Int pos) => list.Insert(UnityEngine.Random.Range(0, list.Count), pos);
    }
}