using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.Linq;

namespace scene12
{
    public class SignLayout
    {
        public Sign[][] layout;
        public readonly int width;
        public readonly int height;

        public Sign Get(int row, int col) => layout[row][col];
        public Sign Get(Vector2Int location) => layout[location.x][location.y];
        public SignLayout(int width, int height)
        {
            layout = new Sign[height][];
            for (int index = 0; index < height; index++)
            {
                layout[index] = new Sign[width];
            }
            this.width = width;
            this.height = height;
        }

        public void Clear()
        {
            for (int index = 0; index < height; index++)
            {
                layout[index] = new Sign[width];
            }
        }

        /// <summary>
        /// ǰǷп
        /// </summary>
        /// <returns></returns>
        public bool IsMatchable()
        {
            foreach (var (row, col) in
                from i in Enumerable.Range(0, height)
                from j in Enumerable.Range(0, width)
                select (i, j))
            {
                if (Get(row, col) == Sign.None) continue;
                if (GetLinkable(row, col).FindAll(point => 
                    layout[point.x][point.y] == layout[row][col] 
                    && (point.x != row || point.y != col)
                    ).Count > 0)
                    return true;
            }

            return false;
        }

        public bool IsSameSign(int row1, int col1, int row2, int col2)
            => Get(row1, col1) == Get(row2, col2);

        private List<Vector2Int> GetLinkable(int row, int col)
        {
            //ӵĵ
            List<Vector2Int> canLink = new List<Vector2Int>();
            canLink.Add(new Vector2Int(row, col));
            List<Vector2Int> finds = new List<Vector2Int>();
            //һ
            finds.AddRange(FindReachablePoints(row, col));
            canLink.AddRange(finds);
            finds.Clear();
            //ڶ
            canLink.FindAll(point=>Get(point)==Sign.None).ForEach(point => finds.AddRange(FindReachablePoints(point.x, point.y)));
            canLink.AddRange(finds);
            canLink = canLink.Distinct().ToList();
            finds.Clear();

            //
            canLink.FindAll(point => Get(point) == Sign.None).ForEach(point => finds.AddRange(FindReachablePoints(point.x, point.y)));
            canLink.AddRange(finds);
            finds.Clear();
            finds = null;
            canLink = canLink.Distinct().ToList();

            return canLink;
        }
        /// <summary>
        /// ĳͼǷ
        /// </summary>
        /// <param name="row"></param>
        /// <param name="col"></param>
        /// <returns></returns>
        public bool IsCanMatch(int row1, int col1, int row2, int col2)
        {
            if (!IsSameSign(row1, col1, row2, col2)) return false;

            var linkList = GetLinkable(row1, col1);

            return linkList.Contains(new Vector2Int(row2, col2));
        }

        //ѰҺϿԵĵ
        private List<Vector2Int> FindReachablePoints(int row, int col)
        {
            List<Vector2Int> result = new List<Vector2Int>();

            void Finds(int start, int end, int fix, bool isFixRow)
            {
                if (start == end) return;
                int step = start < end ? 1 : -1;
                Vector2Int location;
                for (int temp = start + step; temp != end + step; temp += step)
                {
                    location = isFixRow ? new Vector2Int(fix, temp) : new Vector2Int(temp, fix);
                    result.Add(location);
                    if (Get(location) != Sign.None)
                    {
                        break;
                    }
                }
            }
            //
            Finds(col, 0, row, true);
            //
            Finds(col, width - 1, row, true);
            //
            Finds(row, 0, col, false);
            //
            Finds(row, height - 1, col, false);

            return result;
        }

        public void SetSign(int row, int col, Sign sign) => layout[row][col] = sign;

        /// <summary>
        /// ĳ
        /// </summary>
        /// <param name="row"></param>
        /// <param name="col"></param>
        public void Match(int row1, int col1, int row2, int col2)
        {
            layout[row1][col1] = Sign.None;
            layout[row2][col2] = Sign.None;
        }

    }

    //ͼ
    public enum Sign
    {
        None = 0,
        Win = 1,
        Haha,
        Cece,
        Run,
        Kawai,
        W,
        Call,
        Marry,
        Scary,
        Black
    }
}