using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using UnityEngine.UI;

namespace scene12
{
    public class Shisensho : MonoBehaviour
    {

        public List<Sprite> sprites;
        public GameObject content;
        public GameObject image;

        private SignLayout now;

        //ʵĿȺ͸߶
        const int Width = 20;
        const int Height = 10;

        //ͼ
        int signKinds;

        Vector2Int lastClick = new Vector2Int(-1, -1);

        private void Awake()
        {
            signKinds = System.Enum.GetNames(typeof(Sign)).Length - 1;

            var fact = new SignLayoutFactory(Width, Height);

            now = fact.Create(signKinds);

            GenerateImages(now);
        }

        public void Click(Vector2Int pos)
        {
            //Debug.Log(lastClick + "" + pos);

            var tempButton = buttons[pos.x * Width + pos.y];
            SetAlpha(tempButton, 127);

            //ѡȡһͼƬ
            if (lastClick == new Vector2Int(-1, -1))
            {
                lastClick = pos;
                return;
            }

            //ظȡѡ
            if (lastClick == pos)
            {
                tempButton = buttons[lastClick.x * Width + lastClick.y];
                SetAlpha(tempButton, 255);
                lastClick = new Vector2Int(-1, -1);
                return;
            }

            //£lastposŲͬͼƬ

            if (now.IsCanMatch(lastClick.x + 1, lastClick.y + 1, pos.x + 1, pos.y + 1))
            {
                //ƥ䣬͸
                now.Match(lastClick.x + 1, lastClick.y + 1, pos.x + 1, pos.y + 1);
                tempButton = buttons[lastClick.x * Width + lastClick.y];
                tempButton.interactable = false;
                SetAlpha(tempButton, 0);
                tempButton = buttons[pos.x * Width + pos.y];
                tempButton.interactable = false;
                SetAlpha(tempButton, 0);
            }
            else
            {
                //ƥ䣬͸Ȼԭ
                tempButton = buttons[lastClick.x * Width + lastClick.y];
                SetAlpha(tempButton, 255);
                tempButton = buttons[pos.x * Width + pos.y];
                SetAlpha(tempButton, 255);
            }

            //ƥÿ
            lastClick = new Vector2Int(-1, -1);

            void SetAlpha(Button button,int alpha)
            {
                var color = button.image.color;
                color.a = alpha/255f;
                button.image.color = color;
            }
        }

        private List<Button> buttons = new List<Button>(Width * Height);

        public void GenerateImages(SignLayout layout)
        {
            var group = content.GetComponent<GridLayoutGroup>();
            group.constraint = GridLayoutGroup.Constraint.FixedColumnCount;
            group.constraintCount = Width;

            foreach (var (row, col) in
                from i in Enumerable.Range(0, Height)
                from j in Enumerable.Range(0, Width)
                select (i, j))
            {
                Vector2Int temp = new Vector2Int(row, col);
                var ins = Instantiate(image, group.transform);
                ins.name = row + " " + col;
                var b = ins.GetComponent<Button>();
                buttons.Add(b);
                b.onClick.AddListener(() => Click(new Vector2Int(temp.x, temp.y)));
                b.image.sprite = sprites[(int)layout.Get(row + 1, col + 1) - 1];
            }
        }
    }
}

