using System.Collections;
using System.Collections.Generic;
using Utility.Date;

namespace scene1
{
    //
    public class StorageRack
    {
        public LinkedList<Box> boxes;
        List<int> usefulID;
        BoxType type;
        public int Size { get; private set; }
        public int Count => boxes.Count;
        private StorageRack() { }
        public StorageRack(int maxSize, BoxType StorageType)
        {
            boxes = new LinkedList<Box>();
            usefulID = new List<int>(maxSize);
            usefulID.AddRange(System.Linq.Enumerable.Range(0, maxSize));
            Size = maxSize;
            type = StorageType;
        }
        //ϼ
        public void PutOn(Box box)
        {
            box.id = usefulID[0];
            usefulID.RemoveAt(0);
            MessageMgr.Ins.BoxOn(box);
            boxes.AddLast(box);
        }
        //ȡ
        public void PutOff(Box box, OffType type)
        {
            usefulID.Add(box.id);
            MessageMgr.Ins.BoxOff(box, type);
            Statistics.Ins.OnBoxOff(box);
            boxes.Remove(boxes.Find(box));
        }
        public void PutOff(LinkedListNode<Box> box, OffType type)
        {
            PutOff(box.Value, type);
        }
        //
        public void Clean(Box box)
        {
            usefulID.Add(box.id);
            MessageMgr.Ins.BoxClean(box);
            Statistics.Ins.OnBoxClean(box);
            boxes.Remove(box);
        }
        public void Clean(LinkedListNode<Box> box)
        {
            usefulID.Add(box.Value.id);
            MessageMgr.Ins.BoxClean(box.Value);
            Statistics.Ins.OnBoxClean(box.Value);
            boxes.Remove(box);
        }
        //ÿսʱ
        public void ClearExpired(Date nowTime)
        {
            LinkedListNode<Box> nowBox = boxes.First;
            bool isNoClean = true;
            while (nowBox is not null)
            {
                if (nowBox.Value.IsExpired(nowTime))
                {
                    if (nowBox.Next is not null)
                    {
                        nowBox = nowBox.Next;
                        Clean(nowBox.Previous);
                        isNoClean = false;
                    }
                    else
                    {
                        Clean(nowBox);
                        isNoClean = false;
                        break;
                    }
                }
                else
                {
                    nowBox = nowBox.Next ?? null;
                }
            }
            if (isNoClean) MessageMgr.Ins.NoClean(this.type);
            //id
            usefulID.Sort((x, y) => x.CompareTo(y));

            List<Box> saveList = new List<Box>(boxes);
            Utility.SL.Saver.SaveSingle(saveList, StorageMgr.nowDate.ToString() + $" {type} StorageInfo", UnityEngine.Application.streamingAssetsPath + "/scene1");
        }

    }
    //ôȡߵ
    public enum OffType
    {
        ID = 0,
        PHONE = 1,
    }
}