using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using Utility.Date;
namespace scene1
{
    //Ҫűƽڽ̣GameManagerĴ
    public class StorageMgr : MonoBehaviour
    {
        public static StorageMgr Ins;
        public static Date startDate;
        public static Date nowDate;
        public StorageRack[] storages;
        private void Awake()
        {
            //ʼ
            storages = new StorageRack[3] { new StorageRack(500, BoxType.SMALL), new StorageRack(100, BoxType.MEDIUM), new StorageRack(50, BoxType.BIG) };
            //ʼʱ
            startDate = new Date(2022, 12, 3);
            nowDate = new Date(startDate);
            Ins = this;

            Application.targetFrameRate = 120;
        }
        public void Moring()
        {
            //ϻ
            for (int index = 0; index < 3; index++)
            {
                int Sub = storages[index].Size - storages[index].Count;
                if (Sub <= 0) continue;
                int num = Random.Range(Sub / 10, Mathf.Min(Sub, storages[index].Size / 5 * 2));
                var boxes = EventMgr.GetRandomBoxes((BoxType)index, num, nowDate);
                foreach (Box box in boxes)
                {
                    //
                    storages[index].PutOn(box);
                }
            }

            MessageMgr.Ins.Refresh();
        }

        public void Work()
        {
            //֪ͨȡ
            //¼ǰȡ˼
            Dictionary<People, List<Box>> details = new();

            for (int index = 0; index < 3; index++)
            {
                //ʹͬһˣÿﶼᷢһ֪ͨҲ
                foreach (Box box in storages[index].boxes)
                {
                    //֪ͨȡҲǰҲ
                    var people = EventMgr.NotificateThePeople(box);
                    if (people is null) continue;
                    //ȡǰ½һ¼
                    if (!details.ContainsKey(people))
                        details.Add(people, new List<Box>() { box });
                    //ȡаڴ˼¼
                    else
                        details[people].Add(box);
                }
            }
            //ǰȡ˽ȡ
            foreach (var pair in details)
            {
                //ÿ˵ȡʽ
                OffType type = EventMgr.GetRandomType();
                foreach (var box in pair.Value)
                {
                    storages[(int)box.type].PutOff(box, type);
                }

            }

            MessageMgr.Ins.Refresh();
        }

        public void Night()
        {
            //
            for (int index = 0; index < 3; index++)
            {
                storages[index].ClearExpired(nowDate);
            }
            nowDate.SetToNextDay();
            Statistics.Ins.Refresh();
            MessageMgr.Ins.Refresh();
            
        }
    }

}