using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace scene1
{

    public class Statistics : MonoBehaviour
    {
        public static Statistics Ins;

        private void Awake()
        {
            Ins = this;
        }
        //ͳƵĳ˼ĳΪĴ
        public class Info
        {
            public string name;
            public int times;
            public Info(string _name, int _times)
            {
                (name, times) = (_name, _times);
            }
            public static Info Default = new Info("", 0);
        }
        public Text time;
        //ͳۼȡذ
        List<Info> offlist = new List<Info>(30);
        public Text most1;
        //ۼƱ˻ذ
        List<Info> cleanlist = new List<Info>(30);
        public Text most2;
        public void OnBoxOff(Box box) => OnBoxDoSth(offlist, box);
        public void OnBoxClean(Box box) => OnBoxDoSth(cleanlist, box);
        private void OnBoxDoSth(List<Info> list, Box box)
        {
            string name = box.name;
            var most = list.Find(item => item.name == name);
            if (most is null) list.Add(new Info(name, 1));
            else most.times += 1;
        }
        //ȡֵ
        public Info GetMost(List<Info> list)
        {
            //
            list.Sort((a, b) => -a.times.CompareTo(b.times));
            return list.Count > 0 ? list[0] : Info.Default;
        }
        //ȡܺ
        public int GetSum(List<Info> list)
        {
            int sum = 0;
            list.ForEach(info => sum += info.times);
            return sum;
        }
        public void Refresh()
        {
            string startDate = StorageMgr.startDate.ToChineseString();
            string nowDate = StorageMgr.nowDate.ToChineseString();
            int dis = StorageMgr.nowDate - StorageMgr.startDate;
            time.text = $"{startDate}{nowDate}{dis}";

            Info offmost = GetMost(offlist);
            int offsum = GetSum(offlist);
            most1.text = $"һȡ{offsum} {offmost.name} ȡ࣬ȡ{offmost.times}";

            Info cleanmost = GetMost(cleanlist);
            int cleansum = GetSum(cleanlist);
            most2.text = $"һ˻{cleansum} {cleanmost.name} ˻࣬˻{cleanmost.times}";
        }
    }
}