using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using Utility.Date;

namespace scene1
{

    /// <summary>
    /// ϢѵĹ
    /// </summary>
    public class MessageMgr : MonoBehaviour
    {
        public static MessageMgr Ins;
        public List<GameObject> contents;
        public GameObject Message;
        public Capacity[] capacitys;
        List<string>[] messages;
        Date nowTime => StorageMgr.nowDate;
        int now;
        private void Awake()
        {
            //foreach
            messages = new List<string>[9] { new List<string>(), new List<string>(), new List<string>(), new List<string>(),
            new List<string>(), new List<string>(), new List<string>(), new List<string>(), new List<string>(), };
            Ins = this;
            capacitys = new Capacity[3];
            ChangeShow(BoxType.SMALL);
        }
        public void BoxOn(Box box)
        {
            messages[(int)box.type * 3 + 0].Add($"{nowTime}\n{(int)box.type + 1}-{box.id} Űϼ");
        }
        public void BoxOff(Box box, OffType type)
        {
            string baseText = $"{nowTime}\n{(int)box.type + 1}-{box.id} Ű {box.name} ";
            string tailText;
            if (type == OffType.ID)
                tailText = "ȡ ȡ";
            else //(type == OffType.PHONE)
                tailText = $"ƾֻ { box.phone} ȡ";
            messages[(int)box.type * 3 + 1].Add(baseText + tailText);
        }
        public void BoxClean(Box box)
        {
            messages[(int)box.type * 3 + 2].Add($"{nowTime}\n{(int)box.type + 1}-{box.id}  {box.name} İڣ˻");
        }
        public void NoClean(BoxType type)
        {
            messages[(int)type * 3 + 2].Add($"{nowTime}\nûڰҪ");
        }
        //лǰ
        public void ChangeShow(BoxType type)
        {
            foreach (var obj in contents)
            {
                obj.SetActive(false);
            }
            int num = (int)type;
            for (int i = 0; i < 3; i++)
            {
                contents[num * 3 + i].SetActive(true);
                contents[num * 3 + i].transform.parent.parent.GetComponent<ScrollRect>().content =
                    contents[num * 3 + i].GetComponent<RectTransform>();
            }
        }
        public void ChangeShow(int type)
        {
            ChangeShow((BoxType)type);
        }
        public void Refresh()
        {
            for (int i = 0; i < contents.Count; i++)
            {
                foreach (var str in messages[i])
                {
                    var mes = Get(contents[i].transform);
                    mes.GetComponent<Text>().text = str;
                }
                messages[i].Clear();
            }
            foreach (var i in capacitys) i.OnRefresh();
        }

        //Mini Object Pool
        List<GameObject> ObjectPool = new List<GameObject>(64);
        private void Release(GameObject obj)
        {
            obj.SetActive(false);
            obj.transform.SetParent(null);
            ObjectPool.Add(obj);
        }
        private GameObject Get(Transform parent)
        {
            GameObject obj;
            if (ObjectPool.Count > 0)
            {
                obj = ObjectPool[0];
                obj.transform.SetParent(parent, true);
                ObjectPool.RemoveAt(0);
            }
            else
            {
                obj = Instantiate(Message, parent);
            }
            obj.SetActive(true);
            return obj;
        }

        //Ϣ
        public void ClearMessages()
        {
            contents.ForEach(obj =>
            {
                while (obj.transform.childCount > 0)
                    Release(obj.transform.GetChild(0).gameObject);
            });
        }
        //Ϣڵײ
        public void SetValue()
        {
            for (int i = 0; i < 3; i++)
            {
                contents[i].transform.parent.parent.GetChild(1).GetComponent<Scrollbar>().value = 0;
            }
        }
    }
}